/* PropUnitTest.cpp
 *   This demo demonstrates access to FG4 properties.
 *   (c)2021-2022 Digiteq Automotive  written by Jaroslav Fojtik	*/
#include <stdio.h>

#include <Windows.h>

#include <uuids.h>
#include <strmif.h>


#include "../../shared/FG4iface.h"	// Obtained from compilation FG4iface.idl file.
#include "CameraPropTester.h"


bool ManualTrig = false;


/////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////////////////


int main(int argc, char* argv[])
{
  printf("\n<<<FG4 event testing>>> %dbits (C)2022 Digiteq Automotive", sizeof(size_t)*8);

  for(int i=1; i<argc; i++)
  {
     const char *szToken = argv[i];
     if(stricmp(szToken, "-manual")==0 || stricmp(szToken,"/manual")==0)
     {
       ManualTrig = 1;
       continue;
     }
  }


  HRESULT hResult = CoInitializeEx(NULL, COINIT_MULTITHREADED|COINIT_DISABLE_OLE1DDE);
  if(FAILED(hResult))
  {
    printf("\nCannot initialise COM, error %Xh.", hResult);
    return -1;
  }

    // Locate our capture filter.
    // First, create the device enumerator object
  ICreateDevEnum *piCreateDevEnum;
  hResult = CoCreateInstance(CLSID_SystemDeviceEnum, NULL, CLSCTX_INPROC_SERVER, __uuidof(piCreateDevEnum), reinterpret_cast<void**>(&piCreateDevEnum));
  if(SUCCEEDED(hResult))
  {              
    int Xorder = 0;
        // Get class enumerator for WDM Streaming Capture Devices category
    IEnumMoniker *piEnumMoniker;
    hResult = piCreateDevEnum->CreateClassEnumerator(AM_KSCATEGORY_CAPTURE, &piEnumMoniker, 0);    

    if(SUCCEEDED(hResult))
        hResult = piEnumMoniker->Reset();

    if(SUCCEEDED(hResult))
    {				// Enumerate KS devices
      ULONG cFetched;
      IMoniker* piMoniker;
      while((hResult = piEnumMoniker->Next(1, &piMoniker, &cFetched)) == S_OK)
      {
        IBaseFilter* piFilter;

#ifdef _DEBUG
                // Printout devices we find (ignore any errors)
        LPOLESTR pwszMonikerName;
        if(SUCCEEDED(piMoniker->GetDisplayName( NULL, NULL, &pwszMonikerName)))
        {
          printf("Found device: %S\n", pwszMonikerName);
          CoTaskMemFree(pwszMonikerName);
        }
#endif  // _DEBUG

                // The device we look for is identified by supporting FG4KsproxySampleConfig.
                // Do check this we need to instantiate the filter object and then query it for
                // FG4KsproxySampleConfig.
                // This is not the fastest method.
                // We could rely on filter's name to avoid creating the filter
        hResult = piMoniker->BindToObject(NULL, NULL, __uuidof(piFilter), reinterpret_cast<void**>(&piFilter));
        if(SUCCEEDED(hResult))
        {
	  IFG4KsproxyConfig *piConfig = NULL;
          hResult = piFilter->QueryInterface(__uuidof(piConfig), reinterpret_cast<void**>(&piConfig));
          
          if(FAILED(hResult))
              piFilter->Release();
	  else
	  {
	    LPOLESTR pwszMonikerName;
	    hResult = piMoniker->GetDisplayName( NULL, NULL, &pwszMonikerName); 
	    wchar_t *DevName = SUCCEEDED(hResult)?pwszMonikerName:NULL;
	    if(DevName!=NULL)
	    {
	      DevName = wcsstr(pwszMonikerName,L"}\\");
	      if(DevName) DevName+=2;
            }
	    printf("\nDevice camera #%d found %S", Xorder, (DevName!=NULL)?DevName:L"");
	    if(SUCCEEDED(hResult)) CoTaskMemFree(pwszMonikerName);
	    Xorder++;

	    IFG4KsproxyTriggerConfig *pTrigConfig;
	    hResult = piConfig->QueryInterface(__uuidof(pTrigConfig), reinterpret_cast<void**>(&pTrigConfig));
	    if(FAILED(hResult))
	      printf("\nCannot get interface IFG4KsproxyTriggerConfig, HRESULT %Xh", hResult);
            else
            {
	      if(Xorder==1)
	         TestManTriggerCb(pTrigConfig);
	      pTrigConfig->Release();
            }

	    piFilter->Release(); piFilter=NULL;
	    piConfig->Release(); piConfig=NULL;
          }
        }
        piMoniker->Release();
      }
      if(Xorder==0)
          printf("\nNo FG4 camera found!");
    }
    piEnumMoniker->Release();


        // Get class enumerator for WDM Streaming Capture Devices category
    Xorder = 0;    
    hResult = piCreateDevEnum->CreateClassEnumerator(AM_KSCATEGORY_RENDER, &piEnumMoniker, 0);
    piCreateDevEnum->Release();			// no longer needed.

    if(SUCCEEDED(hResult))
        hResult = piEnumMoniker->Reset();

    if(SUCCEEDED(hResult))
    {				// Enumerate KS devices
      ULONG cFetched;
      IMoniker* piMoniker;
      while((hResult = piEnumMoniker->Next(1, &piMoniker, &cFetched)) == S_OK)
      {
        IBaseFilter* piFilter;

#ifdef _DEBUG
                // Printout devices we find (ignore any errors)
        LPOLESTR pwszMonikerName;
        if(SUCCEEDED(piMoniker->GetDisplayName( NULL, NULL, &pwszMonikerName)))
        {
          printf("Found device: %S\n", pwszMonikerName);
          CoTaskMemFree(pwszMonikerName);
        }
#endif  // _DEBUG

                // The device we look for is identified by supporting FG4KsproxySampleConfig.
                // Do check this we need to instantiate the filter object and then query it for
                // FG4KsproxySampleConfig.
                // This is not the fastest method.
                // We could rely on filter's name to avoid creating the filter
        hResult = piMoniker->BindToObject(NULL, NULL, __uuidof(piFilter), reinterpret_cast<void**>(&piFilter));
        if(SUCCEEDED(hResult))
        {
	  IFG4KsproxyTransmitConfig *poConfig = NULL;                
          hResult = piFilter->QueryInterface(__uuidof(poConfig), reinterpret_cast<void**>(&poConfig));
          
          if(FAILED(hResult))
              piFilter->Release();
	  else
	  {
	    LPOLESTR pwszMonikerName;
            hResult = piMoniker->GetDisplayName( NULL, NULL, &pwszMonikerName);
            wchar_t *DevName = SUCCEEDED(hResult)?pwszMonikerName:NULL;
	    if(DevName!=NULL)
	    {
	      DevName = wcsstr(pwszMonikerName,L"}\\");
	      if(DevName) DevName+=2;
            }
	    printf("\nDevice transmitter #%d found %S", Xorder, (DevName!=NULL)?DevName:L"");
	    if(SUCCEEDED(hResult)) CoTaskMemFree(pwszMonikerName);
	    Xorder++;

	    piFilter->Release(); piFilter=NULL;
	    poConfig->Release(); poConfig=NULL;
          }
        }

        piMoniker->Release();
      }
    }

    piEnumMoniker->Release();
  }

  CoUninitialize();
return 0;
}
