/***********************************************************************************
 *                        Frame Grabber FG4 - Test application
 *                          (c)2019-2024 Digiteq automotive
 ***********************************************************************************/
// Note: This demo uses MFC based dialogs. If you looks for the most simple example,
//  please have a look at SimpleProp.cpp.
#include "stdafx.h"
#include "FG4ProxyPluginTestApp.h"
#include "FG4ProxyPluginTestAppDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// Batch timer ID
#define IDTIMER_BATCH    100
#define IDTIMER_TRIGGERS 101


#define BATCH_TIMER_SPEEDms	2000
#define BATCH_REBUILD_GRAPH	49
#define BATCH_RESTART_VIDEO	7


// CAboutDlg dialog used for App About

class CAboutDlg: public CDialog
{
public:
    CAboutDlg();

    // Dialog Data
    enum { IDD = IDD_ABOUTBOX };

protected:
    virtual void DoDataExchange( CDataExchange* pDX );      // DDX/DDV support

    // Implementation
    DECLARE_MESSAGE_MAP()
};


CAboutDlg::CAboutDlg() : CDialog( CAboutDlg::IDD )
{
}


void CAboutDlg::DoDataExchange( CDataExchange* pDX )
{
  CDialog::DoDataExchange( pDX );
}


BEGIN_MESSAGE_MAP( CAboutDlg, CDialog )
END_MESSAGE_MAP()



// CFG4ProxyPluginTestAppDlg dialog

CFG4ProxyPluginTestAppDlg::CFG4ProxyPluginTestAppDlg() :
    CDialog( CFG4ProxyPluginTestAppDlg::IDD, NULL ),
    m_piGraphBuilder(NULL),
    m_piMediaControl(NULL),
    m_piCaptureFilter(NULL),
    m_piConfig(NULL),
    m_uTimer(0),
    m_uTimer2(0),
    m_ulBatchCount(0),
    m_Temperature(0)
{
  m_hIcon = AfxGetApp()->LoadIcon( IDR_MAINFRAME );

    // Restore properties
  m_DualPixel = AfxGetApp()->GetProfileInt(_T(""), _T( "DualPixel" ), 1);
  m_ColorMapping = AfxGetApp()->GetProfileInt(_T(""), _T( "ColorMapping" ), 1);
  m_StreamId = AfxGetApp()->GetProfileInt(_T(""), _T( "StreamId" ), 1);
  m_GmslFEC = AfxGetApp()->GetProfileInt(_T(""), _T( "GmslFEC" ), 1);
  m_VerticalFlip = AfxGetApp()->GetProfileInt(_T(""), _T("VerticalFlip"), 1);
  m_GmslRate = AfxGetApp()->GetProfileInt(_T(""), _T("GmslRate"), 1);
  m_DeGap2VSYNC = AfxGetApp()->GetProfileInt(_T(""), _T("DeGap2VSYNC"), 1);
  m_DeGap2HSYNC = AfxGetApp()->GetProfileInt(_T(""), _T("DeGap2HSYNC"), 1);
  m_EncodeTriggers = AfxGetApp()->GetProfileInt(_T(""), _T( "EncodeTriggers" ), 1);

  m_DeviceOrder = AfxGetApp()->GetProfileInt(_T(""), _T("DeviceOrder"), 1);
  m_TriggerStatus = m_TriggerCount1 = m_TriggerCount2 = 0;
}


CFG4ProxyPluginTestAppDlg::~CFG4ProxyPluginTestAppDlg()
{
    // Persist the rate
  AfxGetApp()->WriteProfileInt(_T(""), _T("DualPixel"), m_DualPixel);
  AfxGetApp()->WriteProfileInt(_T(""), _T("ColorMapping"), m_ColorMapping);
  AfxGetApp()->WriteProfileInt(_T(""), _T("StreamId"), m_StreamId);
  AfxGetApp()->WriteProfileInt(_T(""), _T("GmslFEC"), m_GmslFEC);
  AfxGetApp()->WriteProfileInt(_T(""), _T("VerticalFlip"), m_VerticalFlip);
  AfxGetApp()->WriteProfileInt(_T(""), _T("GmslRate"), m_GmslRate);
  AfxGetApp()->WriteProfileInt(_T(""), _T("DeGap2VSYNC"), m_DeGap2VSYNC);
  AfxGetApp()->WriteProfileInt(_T(""), _T("DeGap2HSYNC"), m_DeGap2HSYNC);
  AfxGetApp()->WriteProfileInt(_T(""), _T("EncodeTriggers"), m_EncodeTriggers);

  AfxGetApp()->WriteProfileInt(_T(""), _T("DeviceOrder"), m_DeviceOrder);
}


void CFG4ProxyPluginTestAppDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  DDX_Text(pDX, IDC_DEVICE_ORDER, m_DeviceOrder);

  DDX_Text(pDX, IDC_DUALPIXEL, m_DualPixel);
  DDV_MinMaxLong(pDX, m_DualPixel, 0, 1);
  DDX_Text(pDX, IDC_STREAM_ID, m_StreamId);
  DDV_MinMaxLong(pDX, m_StreamId, 0, 3);
  DDX_Text(pDX, IDC_COLOR_MAPPING, m_ColorMapping);
  DDX_Text(pDX, IDC_DE_GAP_TO_VSYNC, m_DeGap2VSYNC);
  DDX_Text(pDX, IDC_DE_GAP_TO_HSYNC, m_DeGap2HSYNC);

  DDX_Text(pDX, IDC_EDIT_TRIGSTATUS, m_TriggerStatus);
  DDX_Text(pDX, IDC_EDIT_TRIGCOUNT1, m_TriggerCount1);
  DDX_Text(pDX, IDC_EDIT_TRIGCOUNT2, m_TriggerCount2);

  CString str;
  str.Format(_T("%.2fC"),m_Temperature);
  DDX_Text(pDX, IDC_TEMPERATURE, str);

  int Temp;
  Temp=m_VerticalFlip; DDX_Check(pDX,IDC_CHECK_VFLIP,Temp); m_VerticalFlip=Temp;
  Temp=m_GmslFEC; DDX_Check(pDX,IDC_CHECK_FEC,Temp); m_GmslFEC=Temp;
  Temp=m_GmslRate; DDX_CBIndex(pDX,IDC_CMB_RATE,Temp); m_GmslRate=Temp;
  Temp=m_EncodeTriggers; DDX_Check(pDX,IDC_ENCODE_TRIGERS,Temp); m_EncodeTriggers=Temp;
}


BEGIN_MESSAGE_MAP( CFG4ProxyPluginTestAppDlg, CDialog )
    ON_WM_SYSCOMMAND()
    ON_WM_PAINT()
    ON_WM_QUERYDRAGICON()
    //}}AFX_MSG_MAP
    ON_BN_CLICKED( IDOK, OnBnClickedOk )
    ON_BN_CLICKED( IDCANCEL, OnBnClickedClose )
    ON_BN_CLICKED( IDC_STOP, OnBnClickedStop )
    ON_BN_CLICKED( IDC_BATCH, OnBnClickedBatch )
    ON_BN_CLICKED( IDC_PROPERTIES, OnBnClickedProperties )
    ON_BN_CLICKED( IDC_APPLY, OnBnClickedApply )
    ON_WM_TIMER()
    ON_NOTIFY(TCN_SELCHANGE, IDC_TAB1, &CFG4ProxyPluginTestAppDlg::OnTcnSelchangeTab1)
END_MESSAGE_MAP()


// CFG4ProxyPluginTestAppDlg message handlers


void CFG4ProxyPluginTestAppDlg::InitTabControl(void)
{
  TCITEM tabitem;
  HWND hTab;
  
  GetDlgItem(IDC_TAB1, &hTab);
  memset(&tabitem, 0, sizeof(tabitem));
    
    tabitem.mask = TCIF_TEXT;
	tabitem.cchTextMax = 2;
	
    tabitem.pszText = "Index";
    ::SendMessage(hTab, TCM_INSERTITEM, 0, (LPARAM)&tabitem);

    tabitem.pszText = "TBD";
    ::SendMessage(hTab, TCM_INSERTITEM, 1, (LPARAM)&tabitem);
	
	// Get the position that the dialogs should be displayed
/*
	RECT rt;
	GetWindowRect(GetDlgItem(hwnd, IDC_STATIC1), &rt);
    rt.bottom -= rt.top;
    rt.right  -= rt.left;
	ScreenToClient(hTab, (LPPOINT)&rt);
	
	// Create the dialogs modelessly and move them appropriately
    hDlg[0] = CreateDialog((HINSTANCE)lParam, (LPSTR)IDD_PAGE1, hTab, (DLGPROC)DlgProc1);  
    hDlg[1] = CreateDialog((HINSTANCE)lParam, (LPSTR)IDD_PAGE2, hTab, (DLGPROC)DlgProc2); 
    
    MoveWindow(hDlg[0], rt.left, rt.top, rt.right, rt.bottom, 0);
    MoveWindow(hDlg[1], rt.left, rt.top, rt.right, rt.bottom, 0);
    
    // Show the default dialog    
    ShowWindow(hDlg[0], SW_SHOW); 
*/
}


BOOL CFG4ProxyPluginTestAppDlg::OnInitDialog()
{
  CDialog::OnInitDialog();

    // Add "About..." menu item to system menu.

    // IDM_ABOUTBOX must be in the system command range.
  ASSERT( (IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX );
  ASSERT( IDM_ABOUTBOX < 0xF000 );

  CMenu* pSysMenu = GetSystemMenu( FALSE );
  if( pSysMenu != NULL )
  {
    CString strAboutMenu;
    strAboutMenu.LoadString(IDS_ABOUTBOX);
    if( !strAboutMenu.IsEmpty() )
    {
      pSysMenu->AppendMenu( MF_SEPARATOR );
      pSysMenu->AppendMenu( MF_STRING, IDM_ABOUTBOX, strAboutMenu );
    }
  }

  //HWND hCombo = GetDlgItem(IDC_CMB_RATE);
  //ComboBox_AddString(hCombo,_T("12 Gbit/s"));
  //ComboBox_AddString(hCombo,_T("6 Gbit/s"));
  //ComboBox_AddString(hCombo,_T("3 Gbit/s"));
  //ComboBox_AddString(hCombo,_T("1.5 Gbit/s"));


   InitTabControl();

    // Set the icon for this dialog.  The framework does this automatically
    //  when the application's main window is not a dialog
    SetIcon(m_hIcon, TRUE);       // Set big icon
    SetIcon(m_hIcon, FALSE);      // Set small icon

    UpdateButtons();

    return TRUE;    // return TRUE  unless you set the focus to a control
}

void CFG4ProxyPluginTestAppDlg::OnSysCommand( UINT nID, LPARAM lParam )
{
    if( (nID & 0xFFF0) == IDM_ABOUTBOX )
    {
        CAboutDlg dlgAbout;
        dlgAbout.DoModal();
    }
    else
    {
        CDialog::OnSysCommand( nID, lParam );
    }
}


// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.
void CFG4ProxyPluginTestAppDlg::OnPaint() 
{
    if( IsIconic() )
    {
        CPaintDC dc( this );    // device context for painting

        SendMessage( WM_ICONERASEBKGND, reinterpret_cast< WPARAM >( dc.GetSafeHdc() ), 0 );

        // Center icon in client rectangle
        int cxIcon = GetSystemMetrics( SM_CXICON );
        int cyIcon = GetSystemMetrics( SM_CYICON );
        CRect rect;
        GetClientRect( &rect );
        int x = (rect.Width() - cxIcon + 1) / 2;
        int y = (rect.Height() - cyIcon + 1) / 2;

        // Draw the icon
        dc.DrawIcon( x, y, m_hIcon );
    }
    else
    {
        CDialog::OnPaint();
    }
}


// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFG4ProxyPluginTestAppDlg::OnQueryDragIcon()
{
  return static_cast< HCURSOR >( m_hIcon );
}


void CFG4ProxyPluginTestAppDlg::DisplayError( UINT uIds, ... )
{
    TCHAR szAppMessage[512] = { _T( "" ) };
    CString strErrorMessage;
    va_list args;
    va_start( args, uIds );

    // Load application's error message from the resource file
    VERIFY( strErrorMessage.LoadString( uIds ) );

    DWORD dwLen = ::FormatMessage(
                        FORMAT_MESSAGE_FROM_STRING,
                        (LPCTSTR)strErrorMessage,
                        NULL,
                        LANG_USER_DEFAULT,
                        szAppMessage,
                        sizeof(szAppMessage)/sizeof(szAppMessage[0]),
                        &args );
    ASSERT(dwLen > 0);
    UNREFERENCED_PARAMETER(dwLen);

    AfxMessageBox(szAppMessage);

    va_end(args);
}


void CFG4ProxyPluginTestAppDlg::OnBnClickedOk()
{
  if(m_piCaptureFilter != NULL)
  {
    m_piCaptureFilter->Release();
    m_piCaptureFilter = NULL;
  }
  if(m_piConfig != NULL)
  {
    m_piConfig->Release();
    m_piConfig = NULL;
  }

    // Locate our capture filter.
    // First, create the device enumerator object
  ICreateDevEnum *piCreateDevEnum;
  HRESULT hResult = CoCreateInstance(CLSID_SystemDeviceEnum, NULL, CLSCTX_INPROC_SERVER, __uuidof(piCreateDevEnum), reinterpret_cast<void**>(&piCreateDevEnum));
  if(SUCCEEDED(hResult))
  {
    UpdateData();		// Update data now to ensure m_DeviceOrder beeing set.
    int Xorder = m_DeviceOrder;
        // Get class enumerator for WDM Streaming Capture Devices category
    IEnumMoniker* piEnumMoniker;
    hResult = piCreateDevEnum->CreateClassEnumerator(AM_KSCATEGORY_CAPTURE, &piEnumMoniker, 0);
    piCreateDevEnum->Release();

    if(SUCCEEDED(hResult))
            hResult = piEnumMoniker->Reset();

    if(SUCCEEDED(hResult))
    {
            // Enumerate KS devices
      ULONG cFetched;
      IMoniker* piMoniker;
      while((hResult = piEnumMoniker->Next(1, &piMoniker, &cFetched)) == S_OK)
      {
        IBaseFilter* piFilter;

#ifdef _DEBUG
                // Printout devices we find (ignore any errors)
        LPOLESTR pwszMonikerName;
        if(SUCCEEDED(piMoniker->GetDisplayName( NULL, NULL, &pwszMonikerName)))
        {
          TRACE1("OnBnClickedOk: found device: %S\n", pwszMonikerName);
          CoTaskMemFree(pwszMonikerName);
        }
#endif  // _DEBUG

                // The device we look for is identified by supporting FG4KsproxySampleConfig.
                // Do check this we need to instantiate the filter object and then query it for
                // FG4KsproxySampleConfig.
                // This is not the fastest method.
                // We could rely on filter's name to avoid creating the filter
        hResult = piMoniker->BindToObject(NULL, NULL, __uuidof(piFilter), reinterpret_cast<void**>(&piFilter));
        if(SUCCEEDED(hResult))
        {                 
          hResult = piFilter->QueryInterface(__uuidof(m_piConfig), reinterpret_cast< void**>(&m_piConfig));
          if(FAILED(hResult))
              piFilter->Release();
	  else
	  {
	    if(Xorder > 0)
	    {
	      Xorder--;
	      piFilter->Release(); piFilter=NULL;
	      m_piConfig->Release(); m_piConfig=NULL;
	      hResult = E_FAIL;
	    }
            else
            {
              m_piCaptureFilter = piFilter;

                        // Set the rate and request it back to make sure that the rate was successfully
                        // applied and if not then update the controls
			//UpdateData();
              if(FAILED(m_piConfig->SetOldiLaneWidth(m_DualPixel)))
	      {
                m_piConfig->GetOldiLaneWidth(&m_DualPixel);
              }
	      if(FAILED(m_piConfig->SetGmslStreamId(m_StreamId)))
              {
                m_piConfig->GetGmslStreamId(&m_StreamId);
              }
	      if(FAILED(m_piConfig->SetColorMapping(m_ColorMapping)))
              {
		m_piConfig->GetColorMapping(&m_ColorMapping);
              }
	      if(FAILED(m_piConfig->SetVFlip(m_VerticalFlip)))
	      {
		m_piConfig->GetVFlip(&m_VerticalFlip);
	      }
	      if(FAILED(m_piConfig->SetGmslFEC(m_GmslFEC)))
	      {
		m_piConfig->GetGmslFEC(&m_GmslFEC);
              }
	      if(FAILED(m_piConfig->SetGmslMode(m_GmslRate)))
	      {
		m_piConfig->GetGmslMode(&m_GmslRate);
	      }
	      if(FAILED(m_piConfig->SetDeGap2VSYNC(m_DeGap2VSYNC)))
	      {
		m_piConfig->GetDeGap2VSYNC(&m_DeGap2VSYNC);
	      }
	      if(FAILED(m_piConfig->SetDeGap2HSYNC(m_DeGap2HSYNC)))
	      {
		m_piConfig->GetDeGap2HSYNC(&m_DeGap2HSYNC);
	      }
	      if(FAILED(m_piConfig->SetEncodeTriggers(m_EncodeTriggers)))
	      {
		m_piConfig->GetEncodeTriggers(&m_EncodeTriggers);
              }
	      m_piConfig->GetTriggerStatus(&m_TriggerStatus);
	      m_piConfig->GetTriggerCounters(&m_TriggerCount1,&m_TriggerCount2);
	      m_piConfig->GetCoreTemp(&m_Temperature);
              UpdateData(FALSE);
            }
          }
        }

        piMoniker->Release();

        if(SUCCEEDED(hResult))
        {
	  if(m_piConfig != NULL)
              m_uTimer2 = SetTimer(IDTIMER_TRIGGERS, 500, NULL);
          break;
        }
      }

      if(hResult == S_FALSE) hResult=VFW_E_NOT_FOUND;
    }

        piEnumMoniker->Release();
    }

    if( FAILED( hResult ) )
        DisplayError( IDS_ERROR_CAPTUREDEVICE, hResult );
    else
    {
        // Create the filter graph object
      hResult = CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC_SERVER, __uuidof(m_piGraphBuilder), reinterpret_cast<void**>(&m_piGraphBuilder));
      if(SUCCEEDED(hResult))
      {
            // Query for playback control interface
        hResult = m_piGraphBuilder->QueryInterface(__uuidof(m_piMediaControl), reinterpret_cast<void**>(&m_piMediaControl));
        if(SUCCEEDED(hResult))
        {
                // Add capture filter to the graph and render its output pin
          hResult = m_piGraphBuilder->AddFilter( m_piCaptureFilter, NULL );
          if(SUCCEEDED(hResult))
          {
            IEnumPins* piEnumPins;
            hResult = m_piCaptureFilter->EnumPins( &piEnumPins );
            if(SUCCEEDED(hResult))
                    {
                        // We know that our filter got one pin.
                        // Nevertheless enumerate all pins and find the first output pin and then render it
                        IPin* piPin;
                        while( (hResult = piEnumPins->Next( 1, &piPin, NULL )) == S_OK )
                        {
                            PIN_DIRECTION pinDir;
                            hResult = piPin->QueryDirection( &pinDir );
                            if( SUCCEEDED( hResult ) && pinDir == PINDIR_OUTPUT )
                            {
                                hResult = m_piGraphBuilder->Render( piPin );
                                piPin->Release();
                                break;
                            }

                            piPin->Release();
                        }

                        if( hResult == S_FALSE )
                            hResult = VFW_E_NOT_FOUND;

                        piEnumPins->Release();
                    }
                }
            }
        }

        if( FAILED( hResult ) )
            DisplayError( IDS_ERROR_BUILDGRAPH, hResult );
        else
        {
            hResult = m_piMediaControl->Run();
            if( FAILED( hResult ) )
                DisplayError( IDS_ERROR_RUNGRAPH, hResult );
        }
    }

    if( FAILED( hResult ) )
        OnBnClickedStop();
    else
        UpdateButtons();
}


void CFG4ProxyPluginTestAppDlg::OnBnClickedStop()
{
  if(m_uTimer != 0)	    // Stop the timer (if we are in batch mode)
  {
    KillTimer(m_uTimer);
    m_uTimer = 0;
  }

  if(m_uTimer2 != 0)
  {
    KillTimer(m_uTimer2);
    m_uTimer2 = 0;
  }

  if(m_piMediaControl != NULL)
  {
    m_piMediaControl->Stop();
    m_piMediaControl->Release();
    m_piMediaControl = NULL;
  }

  if(m_piCaptureFilter != NULL)
  {
    m_piCaptureFilter->Release();
    m_piCaptureFilter = NULL;
  }

  if(m_piConfig != NULL)
  {
    m_piConfig->Release();
    m_piConfig = NULL;
  }

  if(m_piGraphBuilder != NULL)
  {
    m_piGraphBuilder->Release();
    m_piGraphBuilder = NULL;
  }

  UpdateButtons();
}


void CFG4ProxyPluginTestAppDlg::OnBnClickedBatch()
{
  OnBnClickedOk();

  if(m_piGraphBuilder != NULL)
  {
    if(m_uTimer!=0) KillTimer(m_uTimer);
    m_uTimer = SetTimer(IDTIMER_BATCH, BATCH_TIMER_SPEEDms, NULL);
  }

  UpdateButtons();
}


/// Show property page, and update potentially changed properties.
void CFG4ProxyPluginTestAppDlg::OnBnClickedProperties()
{
    // Get the list of property pages to display
  ISpecifyPropertyPages* piPages;

  if(m_piCaptureFilter==NULL) return;

  HRESULT hResult = m_piCaptureFilter->QueryInterface(__uuidof( piPages ), reinterpret_cast<void**>(&piPages));
  if(SUCCEEDED(hResult))
  {
    CAUUID Pages;
    hResult = piPages->GetPages(&Pages);
    if(SUCCEEDED(hResult) && Pages.cElems > 0)
    {
      IUnknown *pIU = (IUnknown*)m_piCaptureFilter;
      hResult = OleCreatePropertyFrame(
                            m_hWnd,
                            0,
                            0,
                            L"FG4 Properties",
                            1,
                            &pIU,
                            Pages.cElems,
                            Pages.pElems,
                            LANG_USER_DEFAULT,
                            0,
                            NULL );

            // Properties could have been modified from the property page. Update controls
      if(SUCCEEDED(hResult))
      {
        m_piConfig->GetOldiLaneWidth(&m_DualPixel);
	m_piConfig->GetGmslStreamId(&m_StreamId);
	m_piConfig->GetColorMapping(&m_ColorMapping);
	m_piConfig->GetVFlip(&m_VerticalFlip);
	m_piConfig->GetGmslFEC(&m_GmslFEC);
	m_piConfig->GetGmslMode(&m_GmslRate);
	m_piConfig->GetDeGap2VSYNC(&m_DeGap2VSYNC);
	m_piConfig->GetDeGap2HSYNC(&m_DeGap2HSYNC);
        m_piConfig->GetEncodeTriggers(&m_EncodeTriggers);
        UpdateData(FALSE);
      }

      CoTaskMemFree(Pages.pElems);
    }

  piPages->Release();
  }

  if(FAILED(hResult))
      DisplayError(IDS_ERROR_PROPERTYSHEET, hResult);
}


void CFG4ProxyPluginTestAppDlg::OnBnClickedApply()
{
  if( m_piConfig != NULL )
  {
    UpdateData();
    m_piConfig->SetOldiLaneWidth(m_DualPixel);
    m_piConfig->SetGmslStreamId(m_StreamId);
    m_piConfig->SetColorMapping(m_ColorMapping);
    m_piConfig->SetVFlip(m_VerticalFlip);
    m_piConfig->SetGmslFEC(m_GmslFEC);
    m_piConfig->SetGmslMode(m_GmslRate);
    m_piConfig->SetDeGap2VSYNC(m_DeGap2VSYNC);
    m_piConfig->SetDeGap2HSYNC(m_DeGap2HSYNC);
    m_piConfig->SetEncodeTriggers(m_EncodeTriggers);
  }
}


void CFG4ProxyPluginTestAppDlg::OnBnClickedClose()
{
    // Make sure that we stopped the test if any
  OnBnClickedStop();

  OnOK();
}


void CFG4ProxyPluginTestAppDlg::OnTimer(UINT_PTR uIDEvent)
{
  if(uIDEvent == IDTIMER_TRIGGERS)
  {
    if(m_piConfig != NULL)
    {
    m_piConfig->GetTriggerStatus(&m_TriggerStatus);
    m_piConfig->GetTriggerCounters(&m_TriggerCount1,&m_TriggerCount2);
    m_piConfig->GetCoreTemp(&m_Temperature);
    UpdateData(FALSE);
    }   
  }
  else if(uIDEvent == IDTIMER_BATCH)
  {
        // Make sure that this is not the timer event that was queued
        // while the graph got destroyed in the meantime due to the user pressing Stop button
    if(m_piGraphBuilder != NULL)
    {
#ifdef _DEBUG
      FILE* pFile = fopen( "FG4ProxyPluginTestApp.log", "a+" );
#endif

      ++m_ulBatchCount;
#ifdef _DEBUG
      if( pFile != NULL )
          fprintf( pFile, "Batch count: %lu\n", m_ulBatchCount );
#endif

      if((m_ulBatchCount % BATCH_REBUILD_GRAPH) == 0)
      {
                // Rebuild the graph
#ifdef _DEBUG
        if(pFile != NULL)
            fprintf(pFile, "Rebuild the graph\n");
#endif
        OnBnClickedStop();
        OnBnClickedOk();
	if(m_uTimer==0)		// Restart batch timer.
	    m_uTimer = SetTimer(IDTIMER_BATCH, BATCH_TIMER_SPEEDms, NULL);
      }
      else if( (m_ulBatchCount % BATCH_RESTART_VIDEO) == 0 )
      {
                // Restart the graph
#ifdef _DEBUG
        if(pFile != NULL)
            fprintf(pFile, "Restart the graph\n");
#endif
        m_piMediaControl->Stop();

        HRESULT hResult = m_piMediaControl->Run();
        if(FAILED(hResult))
        {
          DisplayError(IDS_ERROR_RUNGRAPH, hResult);
          OnBnClickedStop();	// Abort batch after failure.
        }
      }

            // Tweak some property
      if(m_piConfig != NULL)
      {
        long lRate = static_cast<long>((m_ulBatchCount % 100) + 1);
	if(SUCCEEDED(m_piConfig->SetVFlip(lRate & 1)))
        {
          m_VerticalFlip = lRate & 1;
	}
#ifdef _DEBUG
        else
	  {if(pFile!=NULL) fprintf(pFile,"m_piConfig->SetVFlip failed\n", lRate);}
#endif
	if(SUCCEEDED(m_piConfig->SetColorMapping((lRate&2)==0?0:1)))
        {
          m_ColorMapping = (lRate&2)==0?0:1;
	}
#ifdef _DEBUG
        else
	  {if(pFile!=NULL) fprintf(pFile,"m_piConfig->SetColorMapping failed\n", lRate);}
#endif

#ifdef _DEBUG
        if(pFile != NULL)
            fprintf(pFile, "Set SetVFlip: %ld, m_ColorMapping:%ld \n", m_VerticalFlip,m_ColorMapping);
#endif
      }

#ifdef _DEBUG
      if(pFile != NULL)
          fclose(pFile);
#endif
    }
  }
  else
     CDialog::OnTimer(uIDEvent);
}


void CFG4ProxyPluginTestAppDlg::UpdateButtons()
{
  GetDlgItem(IDOK)->EnableWindow( m_piGraphBuilder == NULL );
  GetDlgItem(IDC_STOP)->EnableWindow( m_piGraphBuilder != NULL );
  GetDlgItem(IDC_BATCH)->EnableWindow( m_piGraphBuilder == NULL );
	// Do not show properties window in batch mode
  GetDlgItem(IDC_PROPERTIES)->EnableWindow(m_piGraphBuilder != NULL && m_uTimer == 0);
}


void CFG4ProxyPluginTestAppDlg::OnTcnSelchangeTab1(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here
/*  int CurSel = GetDlgItem(IDC_TAB1)->GetCurSel();

  switch(CurSel)
  {
    case 0:
        m_page1.ShowWindow(true);
        m_page2.ShowWindow(false);
        break;
    case 1:
        m_page1.ShowWindow(false);
        m_page2.ShowWindow(true);
        break;
  }
*/
  *pResult = 0;
}
