/***********************************************************************************
 *                                 Frame Grabber FG4
 *                          (c)2019-2024 Digiteq automotive
 ***********************************************************************************/
#pragma once

#include "../../shared/FG4iface.h"


// CFG4ProxyPluginTestAppDlg dialog
class CFG4ProxyPluginTestAppDlg: public CDialog
{
public:
    // Construction
	CFG4ProxyPluginTestAppDlg();
    ~CFG4ProxyPluginTestAppDlg();

    // Dialog Data
	enum { IDD = IDD_FG4PROXYPLUGINTESTAPP_DIALOG };

public:
    afx_msg void OnBnClickedOk();
    afx_msg void OnBnClickedClose();
    afx_msg void OnBnClickedStop();
    afx_msg void OnBnClickedBatch();
    afx_msg void OnBnClickedProperties();
    afx_msg void OnBnClickedApply();
    afx_msg void OnTimer(UINT_PTR nIDEvent);  // Fixed
    void InitTabControl(void);

    //afx_msg void OnActivate(UINT nState, CWnd *pWndOther, BOOL bMinimized);

    DECLARE_MESSAGE_MAP()

protected:
    // Implementation
	// Generated message map functions
    virtual void DoDataExchange( CDataExchange* pDX );  // DDX/DDV support
    virtual BOOL OnInitDialog();
    afx_msg void OnSysCommand( UINT nID, LPARAM lParam );
    afx_msg void OnPaint();
    afx_msg HCURSOR OnQueryDragIcon();

private:
    HICON                       m_hIcon;

    long                        m_DualPixel;
    long                        m_StreamId;
    long			m_GmslFEC;
    long			m_VerticalFlip;
    long			m_GmslRate;
    long			m_ColorMapping;
    long			m_DeGap2VSYNC;
    long			m_DeGap2HSYNC;
    BOOL                        m_bActive;		///< TRUE when page is visible, FALSE otherwise
    long			m_EncodeTriggers;
    long                        m_DeviceOrder;
    long			m_TriggerStatus;
    unsigned long		m_TriggerCount1;
    unsigned long		m_TriggerCount2;

    IGraphBuilder*              m_piGraphBuilder;
    IMediaControl*              m_piMediaControl;
    IBaseFilter*                m_piCaptureFilter;
    IFG4KsproxyConfig*		m_piConfig;
    UINT_PTR                    m_uTimer;
    UINT_PTR                    m_uTimer2;
    ULONG                       m_ulBatchCount;
    float			m_Temperature;

    void DisplayError( UINT uIds, ... );
    void UpdateButtons();
public:
	afx_msg void OnTcnSelchangeTab1(NMHDR *pNMHDR, LRESULT *pResult);	
};
