/* GbabBMP.cpp
 *   This demo demonstrates extract bitmap bfrom FG4 device using service interface.
 *   It completelly bypasses camera device and it is intended for special use.
 *   (c)2019-2022 Digiteq automotive - programmed by Jaroslav Fojtik
 */
#include <stdio.h>
#include "hudaqlib.h"

#include <Windows.h>

#include "../../lib/daqshare/BarAccess.h"
#include "../../lib/daqshare/xdma.h"

#include "raster.h"
#include "image.h"
#include "ras_prot.h"


DMA_DESCRIPTOR *pDmaDesc;

extern "C" {
unsigned GetTickCount_ms(void);
}


class Raster2D_8BitRGBAext: public Raster2D_8BitRGBA
{
public:
	Raster2D_8BitRGBAext(unsigned Size1D, unsigned Size2D, char *Blob);
	~Raster2D_8BitRGBAext();
};


Raster2D_8BitRGBAext::Raster2D_8BitRGBAext(unsigned NewSize1D, unsigned NewSize2D, char *Blob)
{
  if(Blob==NULL)
  {
    Size1D = Size2D = 0;
    return;
  }

  Data2D = (void **)malloc(sizeof(void *)*NewSize2D);
  if(Data2D==NULL)
  {
    Size1D = Size2D = 0;
    return;
  }

  for(unsigned i=0; i<NewSize2D; i++)
  {    
    Data2D[i] = Blob + 4*i*NewSize1D;
  }
  Size1D = NewSize1D;
  Size2D = NewSize2D;
}

Raster2D_8BitRGBAext::~Raster2D_8BitRGBAext()
{
  free(Data2D);
  Data1D = NULL;
  Data2D = NULL;
  Size1D = Size2D = 0;
}


/////////////////////////////////////////////////////////////////////////////////////////////////


void *DMA_TransferSLOW0(HUDAQHANDLE h, unsigned AreaOffset, unsigned RemoteAddr, unsigned TransferSz)
{
const unsigned MAX_BLOCK = 4;
void *Ptr = NULL;
unsigned ShiftArea=0;
  while(TransferSz > MAX_BLOCK)
  {
    if(ShiftArea>50000)
    {
      DMA_Transfer0(h,AreaOffset,RemoteAddr,TransferSz,ShiftArea);
      break;
    }
    void *Ptr2 = DMA_Transfer0(h,AreaOffset,RemoteAddr,MAX_BLOCK,ShiftArea);
    if(Ptr==NULL) Ptr=Ptr2;
    TransferSz -= MAX_BLOCK;
    ShiftArea += MAX_BLOCK;
    RemoteAddr += MAX_BLOCK;
  }
  return Ptr;
}


void *DMA_TransferSLOW1(HUDAQHANDLE h, unsigned AreaOffset, unsigned RemoteAddr, unsigned TransferSz)
{
const unsigned MAX_BLOCK = 32;
void *Ptr = NULL;
unsigned ShiftArea=0;
  while(TransferSz > MAX_BLOCK)
  {
    void *Ptr2 = DMA_Transfer1(h,AreaOffset,RemoteAddr,MAX_BLOCK,ShiftArea);
    if(Ptr==NULL) Ptr=Ptr2;
    TransferSz -= MAX_BLOCK;
    ShiftArea += MAX_BLOCK;
    RemoteAddr += MAX_BLOCK;
  }
  return Ptr;
}


void GrabImage(HUDAQHANDLE h)
{
unsigned __int64 DMA_MemRaw;
const HudaqResourceInfo *HRI;
int i;
void *Pointer;
size_t BlockSz;
UINT32 BaseAddr0, BaseAddr1;

  i = HudaqGetDMAinfo(h,&DMA_MemRaw,&Pointer,&BlockSz);
  if(BlockSz==0) return;
  HRI = HudaqGetDeviceResources(h);
  if(HRI==NULL) return;

  printf("\n[0]Config 0x0: %Xh", GetDword(HRI->MemResources[0].Base,0x0));
  printf("\n[1]Config 0x30: %Xh", GetDword(HRI->MemResources[0].Base,0x30));
  printf("\n[0]Frame period 0x1C: %u", GetDword(HRI->MemResources[0].Base,0x1C));
  printf("\n[1]Frame period 0x4C: %u", GetDword(HRI->MemResources[0].Base,0x4C));  
  unsigned Res0 = GetDword(HRI->MemResources[0].Base,0x8);
  printf("\n[0]Image Resolution 0x8: %Xh %ux%u", Res0, Res0>>16, Res0&0xFFFF);  
  unsigned Res1 = GetDword(HRI->MemResources[0].Base,0x38);
  printf("\n[1]Image Resolution 0x38: %Xh %ux%u", Res1, Res1>>16, Res1&0xFFFF);  
  printf("\n[0]Frame counter 0x0C: %X", GetDword(HRI->MemResources[0].Base,0x0C));
  printf("\n[1]Frame counter 0x3C: %X", GetDword(HRI->MemResources[0].Base,0x3C));

  BaseAddr0 = GetDword(HRI->MemResources[0].Base,0x10);
  printf("\n[0]LastBuff address 0x10: %Xh", BaseAddr0);
  BaseAddr1 = GetDword(HRI->MemResources[0].Base,0x40);
  printf("\n[1]LastBuff address 0x40: %Xh", BaseAddr1);

  if(BaseAddr0 >= 0xFFFF0000)
  {
    printf("\nBuffer0 error!");
    StoreDword(HRI->MemResources[0].Base, 0, 0x22);
  }
  if(BaseAddr1 >= 0xFFFF0000)
  {
    printf("\nBuffer1 error!");
    StoreDword(HRI->MemResources[0].Base, 0x30, 0x22);
  }

  if(BaseAddr0>=0xFFFF0000 || BaseAddr1>=0xFFFF0000)
  {
    printf("\nSleep(20);");
    Sleep(20);
    if(BaseAddr0>=0xFFFF0000)
    {
      BaseAddr0 = GetDword(HRI->MemResources[0].Base,0x10);
      printf("\n[0]LastBuff address 0x10: %Xh", BaseAddr0);
    }
    if(BaseAddr1>=0xFFFF0000)
    {
      BaseAddr1 = GetDword(HRI->MemResources[0].Base,0x40);
      printf("\n[1]LastBuff address 0x40: %Xh", BaseAddr1);
    }
  }
  //void *DMA_Transfer0(HUDAQHANDLE h, unsigned AreaOffset, unsigned RemoteAddr, unsigned TransferSz)

  if(Res0==0)
  {
    printf("\nNo resolution on video0 detected yet.");
  }
  else
  {
    if(BaseAddr0 < 0xFFFF0000)
    {
      Pointer = DMA_Transfer0(h, 0,  BaseAddr0, 4*(Res0>>16)*(Res0&0xFFFF), 0);
      if(Pointer==NULL)
      {
        printf("\nDMA transfer0 failed!");
        return;
      }
      Raster2D_8BitRGBAext *pRas = new Raster2D_8BitRGBAext(Res0>>16, Res0&0xFFFF, (char*)Pointer+sizeof(DMA_DESCRIPTOR));
      Image img;
      img.AttachRaster(pRas); 
      SavePicture("obrazek0.bmp",img);
    }
  }

  if(Res1==0)
  {
    printf("\nNo resolution on video1 detected yet.");
  }
  else
  {
    if(BaseAddr1 < 0xFFFF0000)
    {
      Pointer = DMA_Transfer0(h, 0,  BaseAddr1, 4*(Res1>>16)*(Res1&0xFFFF),0);
     if(Pointer==NULL)
      {
        printf("\nDMA transfer1 failed!");
        return;
      }
      Raster2D_8BitRGBAext *pRas = new Raster2D_8BitRGBAext(Res1>>16, Res1&0xFFFF, (char*)Pointer+sizeof(DMA_DESCRIPTOR));
      Image img;
      img.AttachRaster(pRas); 
      SavePicture("obrazek1.bmp",img);
    }
  }
}


static void Testik(void)
{
unsigned Res = 0x1000100;
void *Pointer = calloc(Res>>16, Res&0xFFFF);
  Raster2D_8BitRGBAext *pRas = new Raster2D_8BitRGBAext(Res>>16, Res&0xFFFF, (char*)Pointer+sizeof(DMA_DESCRIPTOR));
  Image img;
  img.AttachRaster(pRas);
  SavePicture("R:\\obrazek.bmp",img);
  free(Pointer);
}


int main(void)
{
HUDAQHANDLE h;
const HudaqResourceInfo *HRI;
int i;
int dev=1;
unsigned __int64 DMA_MemRaw; 
void *Pointer;
size_t BlockSz;
unsigned IrqCounter;

  //Testik(); return 0;

	/* Open first device found of any name. */
  h = HudaqOpenDevice("FG4",1,HudaqOpenNOINIT);
  if(h==0)
  {   
    printf("No HUDAQ device for DQ FG4 found\n"); return -1;
  }

  printf("\n================ DEVICE FOUND ======================");

  HRI = HudaqGetDeviceResources(h);
  printf("\nBus number %d, Slot number %d.",HRI->BusNumber, HRI->SlotNumber);
  printf("\nVendorID %Xh, DeviceID %Xh.",HRI->VendorID,HRI->DeviceID);

  for(i=0; i<HRI->NumMemResources; i++)
  {
    printf("\n Memory resource %d: Base:%Xh, Length:%Xh",
        i, HRI->MemResources[i].Base, HRI->MemResources[i].Length);
  }

  IrqCounter = (unsigned)HudaqGetParameter(h,0,(HudaqParameter)HudaqIRQ);
  printf("\nIRQ counter: %g (%g)",
	     HudaqGetParameter(h,0,(HudaqParameter)HudaqIRQ), HudaqGetParameter(h, 0, (HudaqParameter)(HudaqIRQ+1)));
  HudaqWaitForIrq(h, 10, 1);			// Wait 10ms for possible IRQ

  i = HudaqGetDMAinfo(h,&DMA_MemRaw,&Pointer,&BlockSz);
  if(BlockSz>0 && BlockSz<0x800000)
  {
    HudaqReleaseDMAmem(h);
    BlockSz = 0;
  }
  if(BlockSz==0)
  {
    HudaqAllocateDMAmem(h,0x800000);
    i = HudaqGetDMAinfo(h,&DMA_MemRaw,&Pointer,&BlockSz);
  }
  printf("\nDMA mem raw %llXh, pointer %p, size: %u.", (long long)DMA_MemRaw, Pointer, (unsigned)BlockSz);
  if(BlockSz==0)
  {
    printf("\n Cannot allocate memory for DMA transfer.");
    HudaqCloseDevice(h);
    return -4;
  }

  memset(Pointer, 0xA5, BlockSz);		// Clear DMA transfer area.


  GrabImage(h);

  HudaqReleaseDMAmem(h);
  HudaqCloseDevice(h);
 
  printf("\n");
return 0;
}
