﻿/***************************************************************************************/
/**                     Main window of HW SW switch - prototypes.
 *                          (c)2019-2020 Digiteq automotive
 ****************************************************************************************/
#ifndef __ControlDesk_WINDOW_H__
#define __ControlDesk_WINDOW_H__

#include <QMainWindow>
#include <QTimer>
#include <QDialog>

#include <Windows.h>
#include "hudaqlib.h"


#define OUT1_CONFIG_RW		 0x60
#define OUT1_RESOLUTION_RW	 0x68
#define OUT1_FRAMERATE_RW	 0x74
#define OUT1_NEW_BUF_ADDRESS_R	 0x78
#define OUT2_NEW_BUF_ADDRESS_R	 0x98

#define FRAME_MEAS_CLK		125000000



namespace Ui {
class ControlDeskWindow;
};



class FG4_TestGui: public QMainWindow
{
    Q_OBJECT

public:
    FG4_TestGui(QWidget *parent = 0);
    ~FG4_TestGui();   

    void startSessionLog(QStringList &report);
    void stopSessionLog(QStringList &report);
    void LoadConfiguration(const QString &conf_file);


private slots:
    void slotAttach(void);
    void slotDetach(void);
    void slotTriggered_About(void);
    void slotConfiguration(void);
    void slotTriggered_UMA(void);    
    void slotTriggered_SelfCheck(void);
    void slotStop(void);
    void slotStart(void);
    void slotLogMsgAdded(QString MSG);
    void slotGetFrame(void);
    void slotConnectStage2(void);
    void slotStatusBar(void);
    void slotClearLog(void);
    void slotExit(void);
    void slotStartSynth(void);
    void slotEndSynth(void);
    void slotFeedFrame(void);
    void slotTriggered_SynthParams(void);

protected:
    Ui::ControlDeskWindow *m_ui;
    QString m_fileName;
    bool m_IsAbortionRequested;
    QTimer *m_timer;
    QTimer *m_timer2;
    QTimer *m_timerGen;
    bool m_TimerRunning;
    bool m_IsDirty;
    bool m_Attach;
    HUDAQHANDLE hDaq;
    QImage *pImg;
    unsigned LastBaseAddr;
    unsigned FileCounter;
    unsigned m_SynthHeight, m_SynthWidth, m_FPS;
    bool m_HackLastPixel;

    unsigned m_FrameCounter, m_ReceivedIRQ;
    DWORD OutBuff1;
    bool FeedFrameRunning;

    HANDLE FrameThread;
    volatile bool SigTerminateThread;
    volatile unsigned Frame0, Frame1;
    volatile unsigned IrqLoop;
    unsigned oldFrame0, oldFrame1;
    unsigned oldIrqLoop;

    bool getSelection(void);
    void closeEvent(QCloseEvent *event);
    void StartOrAttach(void);
    void updateWindowTitle(QString scenarioName);
    void keyPressEvent(QKeyEvent *keyEvent);
    static unsigned int __stdcall FG4_JobThread(void *param);

signals:
    void Frame0ready(void);
    void Frame1ready(void);
};


int StartupUDP(void);
int CloseUDP(void);


#endif // __ControlDesk_WINDOW_H__


