﻿/***************************************************************************************/
/**                     Main window of HW SW switch - prototypes.
 *                          (c)2019-2020 Digiteq automotive
 ****************************************************************************************/
#ifndef __ControlDesk_WINDOW_H__
#define __ControlDesk_WINDOW_H__

#include <QMainWindow>
#include <QTimer>
#include <QDialog>

#include "ui_OutputGen.h"

#include <Windows.h>
#include "hudaqlib.h"


namespace Ui {
class ControlDeskWindow;
};



class FG4_TestGui: public QDialog
{
    Q_OBJECT

public:
    FG4_TestGui(QWidget *parent = 0);
    ~FG4_TestGui();   

    void startSessionLog(QStringList &report);
    void stopSessionLog(QStringList &report);
    void LoadConfiguration(const QString &conf_file);


private slots:  
    void slotLogMsgAdded(QString MSG);     
    void slotClearLog(void);

    void slot_Apply(void);    
    void slot_Connect(void);
    void slot_Disconnect(void);
    void slot_Exit(void);
    void slot_ChangeIndex1(int Idx);
    void slot_ChangeIndex2(int Idx);

protected:
    Ui::OutputGen *m_ui;
    QString m_fileName;
    bool m_IsAbortionRequested;
    //bool m_TimerRunning;
    bool m_IsDirty;
    bool m_Attach;
    HUDAQHANDLE hDaq;
    QImage *pImg;
    unsigned LastBaseAddr;
    unsigned FileCounter;

    HANDLE FrameThread;
    volatile bool SigTerminateThread;
    volatile unsigned Frame0, Frame1;
    volatile unsigned IrqLoop;
    unsigned oldFrame0, oldFrame1;
    unsigned oldIrqLoop;

    bool getSelection(void);
    void closeEvent(QCloseEvent *event);
    void updateWindowTitle(QString scenarioName);
    void keyPressEvent(QKeyEvent *keyEvent);
    static unsigned int __stdcall FG4_JobThread(void *param);

//signals:
    //void Frame0ready(void);
    //void Frame1ready(void);
};


int StartupUDP(void);
int CloseUDP(void);


#endif // __ControlDesk_WINDOW_H__


