/* SimpleProp.cpp
 *   This demo demonstrates access to FG4 properties.
 *   (c)2021-2022 Digiteq Automotive  written by Jaroslav Fojtik	*/
#include <stdio.h>

#include <Windows.h>

#include <uuids.h>
#include <strmif.h>


#include "../../shared/FG4iface.h"	// Obtained from compilation FG4iface.idl file.


#define DEVICE_ORDER	1

int main(void)
{
IFG4KsproxyConfig *piConfig = NULL;

  HRESULT hResult = CoInitializeEx(NULL, COINIT_MULTITHREADED|COINIT_DISABLE_OLE1DDE);
  if(FAILED(hResult)) return -1;


    // Locate our capture filter.
    // First, create the device enumerator object
  ICreateDevEnum *piCreateDevEnum;
  hResult = CoCreateInstance(CLSID_SystemDeviceEnum, NULL, CLSCTX_INPROC_SERVER, __uuidof(piCreateDevEnum), reinterpret_cast<void**>(&piCreateDevEnum));
  if(SUCCEEDED(hResult))
  {              
    int Xorder = DEVICE_ORDER;
        // Get class enumerator for WDM Streaming Capture Devices category
    IEnumMoniker* piEnumMoniker;
    hResult = piCreateDevEnum->CreateClassEnumerator(AM_KSCATEGORY_CAPTURE, &piEnumMoniker, 0);
    piCreateDevEnum->Release();

    if(SUCCEEDED(hResult))
        hResult = piEnumMoniker->Reset();

    if(SUCCEEDED(hResult))
    {				// Enumerate KS devices
      ULONG cFetched;
      IMoniker* piMoniker;
      while((hResult = piEnumMoniker->Next(1, &piMoniker, &cFetched)) == S_OK)
      {
        IBaseFilter* piFilter;

#ifdef _DEBUG
                // Printout devices we find (ignore any errors)
        LPOLESTR pwszMonikerName;
        if(SUCCEEDED(piMoniker->GetDisplayName( NULL, NULL, &pwszMonikerName)))
        {
          printf("Found device: %S\n", pwszMonikerName);
          CoTaskMemFree(pwszMonikerName);
        }
#endif  // _DEBUG

                // The device we look for is identified by supporting FG4KsproxySampleConfig.
                // Do check this we need to instantiate the filter object and then query it for
                // FG4KsproxySampleConfig.
                // This is not the fastest method.
                // We could rely on filter's name to avoid creating the filter
        hResult = piMoniker->BindToObject(NULL, NULL, __uuidof(piFilter), reinterpret_cast<void**>(&piFilter));
        if(SUCCEEDED(hResult))
        {                 
          hResult = piFilter->QueryInterface(__uuidof(piConfig), reinterpret_cast<void**>(&piConfig));
          
          if(FAILED(hResult))
              piFilter->Release();
	  else
	  {
	    if(Xorder > 0)
	    {
	      Xorder--;
	      piFilter->Release(); piFilter=NULL;
	      piConfig->Release(); piConfig=NULL;
	      hResult = E_FAIL;
            }
            else
            {
	      long value;
	      if(SUCCEEDED(piConfig->GetVFlip(&value)))
	      {
		value = !value;
		if(SUCCEEDED(piConfig->SetVFlip(value)))
		{
		  printf("Flip property set to %d", value);
		}
	      }
	      piFilter->Release(); piFilter=NULL;
	      piConfig->Release(); piConfig=NULL;
            }
          }
        }

        piMoniker->Release();

        if(SUCCEEDED(hResult)) break;
      }
    }

    piEnumMoniker->Release();    
  }

  CoUninitialize();
return 0;
}
