/***************************************************************************************
 *                                    Frame Grabber FG4
 *                              (c)2019-2025 Digiteq automotive
 ****************************************************************************************/
/** @file
        This file contains properties that could be tuned from userspace.
	The header should be shared among kernel driver and user applications.
	Use it only if you want to do direct IOCTL calls to kernel.
	The standard way is access through COM interface with IDL.
*/
#ifndef _FG4PROPERTIES_H_ 
#define _FG4PROPERTIES_H_


#pragma warning( push )
#pragma warning( disable : 4201 )
#include <ks.h>
#pragma warning( pop )


#define STATIC_PROPSETID_FG4_VIDEOCONTROL\
    0x17a9bb56, 0x727e, 0x449f, 0xbf, 0xa, 0xfa, 0xc8, 0x40, 0xe4, 0xd1, 0xff
DEFINE_GUIDSTRUCT("17a9bb56-727e-449f-bf0a-fac840e4d1ff", PROPSETID_FG4_VIDEOCONTROL);
                  
#define PROPSETID_FG4_VIDEOCONTROL DEFINE_GUIDNAMED(PROPSETID_FG4_VIDEOCONTROL)

/// Camera kernel property numbers.
typedef enum {
    KSPROPERTY_FG4_PROP_COUNT,			// R	Returns number of supported input properties.
    KSPROPERTY_FG4_CHANNEL,			// R	Physical channel on FG4: 0,1 for inputs.
    KSPROPERTY_FG4_SERIAL_NUMBER,		// R	Serial number of the device, same for all channels.
    KSPROPERTY_FG4_OLDI_LANE_W,			// RW	SINGLE, DUAL
    KSPROPERTY_FG4_GMSL_RATE,			// RW	0: 12 Gbps/GMSL3, 1: 6 Gbps/GMSL2, 2: 3 Gbps/GMSL2, 3: 1.5Gbps/GMSL2
    KSPROPERTY_FG4_STREAM_ID,			// RW	0, 1, 2, 3
    KSPROPERTY_FG4_COLOR_MAPPING,		// RW	0, 1
    KSPROPERTY_FG4_FEC,				// RW	enable, disable
    KSPROPERTY_FG4_VERTICAL_FLIP,		// RW	vertical image flip
    KSPROPERTY_FG4_DE_GAP_2_VS,			// RW   10...65535
    KSPROPERTY_FG4_DE_GAP_2_HS,			// RW   2...65535
    KSPROPERTY_FG4_HSYNC_STAT,			// R
    KSPROPERTY_FG4_VSYNC_STAT,			// R
    KSPROPERTY_FG4_LINK_LOCK_STAT,		// R
    KSPROPERTY_FG4_PCLK_STAT,			// R
    KSPROPERTY_FG4_FRAME_COUNTER,		// R	Frame counter
    KSPROPERTY_FG4_FPDL3_INPUT_WIDTH,		// RW	Sets number of deserializer input lines 1 or 2; 0-auto,1-single,2-dual
    KSPROPERTY_FG4_FPGA_FW_ID,			// R	Get firmware identifier.
    KSPROPERTY_FG4_ENCODE_TRIGGERS,		// RW	Request to encode triggers into A channel.
    KSPROPERTY_FG4_RES_DETECTED,		// R	Detected resolution of frame grabber might be different from DShow stream.
    KSPROPERTY_FG4_PCLK_FREQUENCY,		// R
    KSPROPERTY_FG4_MODULE_ID,			// R	ID of replacable FG module 0x10 FPDLINK3; 0x20,0x30,0x40 GMSL; 0xFF failure.
    KSPROPERTY_FG4_SKIPPED_FRAMECOUNT,		// R
    KSPROPERTY_FG4_TRIGGER_STATUS,		// R	Get triger bit flags.
    KSPROPERTY_FG4_DRIVER_VERSION,		// R	Get driver version
    KSPROPERTY_FG4_VIDEO_VALID,			// R	Video validity flag.
    KSPROPERTY_FG4_DEFAULT_COLOR,		// RW	Default color displayed when video halts. MMRRGGBB MM-mode, RR-red GG-Green, BB-Blue.
    KSPROPERTY_FG4_INPUT_FREQ_RANGE,		// RW	Input frequency range: 0 f<50MHz; 1 f>50MHz

    KSPROPERTY_FG4_HSYNC_POLARITY,		// R	Detected H polarity 0=LowActive, 1=HighActive
    KSPROPERTY_FG4_VSYNC_POLARITY,		// R	Detected V polarity 0=LowActive, 1=HighActive
    KSPROPERTY_FG4_HFRONT_PORCH,		// R
    KSPROPERTY_FG4_VFRONT_PORCH,		// R
    KSPROPERTY_FG4_HBACK_PORCH,			// R
    KSPROPERTY_FG4_VBACK_PORCH,			// R
    KSPROPERTY_FG4_HSYNC_WIDTH,			// R
    KSPROPERTY_FG4_VSYNC_WIDTH,			// R
    KSPROPERTY_FG4_CORE_TEMP,			// R	T = ((read_value*503.975)/4096)-273.15 [C]
    KSPROPERTY_FG4_TRIGGER_COUNTERS,		// R	Get two 16 bit couters of both triggers.
    KSPROPERTY_FG4_FRAMEPERIOD,			// R	Currently detected frame period, might be different from DShow stream.
    KSPROPERTY_FG4_PROP_WR_TIMESTAMP,		// R	Last write access to properties

    KSPROPERTY_FG4_END_WATERMARK		// N/A
} KSPROPERTY_FG4_VIDEOCONTROL;


#define STATIC_PROPSETID_FG4_TRANSMIT_CONTROL\
    0x50e4c9d, 0x153b, 0x4a62, 0xa4, 0x82, 0xa7, 0xff, 0xae, 0xe1, 0xb4, 0xa6
DEFINE_GUIDSTRUCT("050E4C9D-153B-4a62-A482-A7FFAEE1B4A6", PROPSETID_FG4_TRANSMIT_CONTROL);
                  
#define PROPSETID_FG4_TRANSMIT_CONTROL DEFINE_GUIDNAMED(PROPSETID_FG4_TRANSMIT_CONTROL)

/// Renderer kernel property numbers.
typedef enum {
    KSPROPERTY_FG4OUT_PROP_COUNT,		// R	Returns number of supported output properties.
    KSPROPERTY_FG4OUT_CHANNEL,			// R	Physical channel on FG4:  2,3 for outputs.
    KSPROPERTY_FG4OUT_SERIAL_NUMBER,		// R	Serial number of the device, same for all channels.
    KSPROPERTY_FG4OUT_FPGA_FW_ID,		// R	Get firmware identifier.
    KSPROPERTY_FG4OUT_HSYNC_POLARITY,		// RW
    KSPROPERTY_FG4OUT_VSYNC_POLARITY,		// RW
    KSPROPERTY_FG4OUT_DE_POLARITY,		// RW
    KSPROPERTY_FG4OUT_HFRONT_PORCH,		// RW
    KSPROPERTY_FG4OUT_VFRONT_PORCH,		// RW
    KSPROPERTY_FG4OUT_HBACK_PORCH,		// RW
    KSPROPERTY_FG4OUT_VBACK_PORCH,		// RW
    KSPROPERTY_FG4OUT_HSYNC_WIDTH,		// RW
    KSPROPERTY_FG4OUT_VSYNC_WIDTH,		// RW
    KSPROPERTY_FG4OUT_FPDL3_OUTPUT_WIDTH,	// RW   Sets number of serializer output lines 1 or 2; 0-auto,1-single,2-dual

	// These properties are managed. These are not writable when output device is fully operating.
	// Writing to these properties violates Direct show standard. They are intended for easy
	// loopback without mounting Direct Show graph.
    KSPROPERTY_FG4OUT_SIG_SOURCE,		// R-W	Signal source
    KSPROPERTY_FG4OUT_RESOLUTION,		// R-W	Resolution width/height
    KSPROPERTY_FG4OUT_FRAMEPERIOD,		// RW	Frame rate, it could be overridden even when operating in DShow chain.
    KSPROPERTY_FG4OUT_CH_ACTIVE,		// R	Channel video activity flag.

    KSPROPERTY_FG4OUT_MODULE_ID,		// R	ID of replacable FG module 0x10 FPDLINK3; 0x20,0x30,0x40 GMSL; 0xFF failure.
    KSPROPERTY_FG4OUT_VERTICAL_FLIP,		// RW	vertical image flip
    KSPROPERTY_FG4OUT_DRIVER_VERSION,		// R	Get driver version
    KSPROPERTY_FG4OUT_PCLK_FREQUENCY,		// RW	PCLK frequency [kHz].
    KSPROPERTY_FG4OUT_PCLK_FREQUENCY_REAL,	// RW	PCLK real frequency [kHz].
    KSPROPERTY_FG4OUT_CORE_TEMP,		// R	T = ((read_value*503.975)/4096)-273.15 [C]
    KSPROPERTY_FG4OUT_STATUS,			// R	Channel status: 0-not chained; 1-chained; 2-chained & paused

    KSPROPERTY_FG4OUT_PIN_FRAMEPERIOD,		// RW
    KSPROPERTY_FG4OUT_THROTTLING,     		// RW	Limits framerate of output video.
    KSPROPERTY_FG4OUT_PROP_WR_TIMESTAMP,	// R	Last write access to properties

    KSPROPERTY_FG4OUT_END_WATERMARK		// N/A
} KSPROPERTY_FG4OUT_VIDEOCONTROL;



#define STATIC_KSEVENTSETID_FG4Event \
    0x7e630b0a, 0x2075, 0x4ccb, 0xa9, 0xed, 0x2, 0xf, 0x9, 0x83, 0xf1, 0xa0
DEFINE_GUIDSTRUCT("7E630B0A-2075-4CCB-A9ED-020F0983F1A0", KSEVENTSETID_FG4Event);
#define KSEVENTSETID_FG4Event DEFINE_GUIDNAMED(KSEVENTSETID_FG4Event)


typedef enum {
    KSEVENT_FG4_EVENT_TRIGGER_CHANGE = 0	// This event is triggered when any of these two signals is triggered.
} KSEVENT_FG4_EVENT_TYPE;


#endif
